/* Include files */

#include <stddef.h>
#include "blas.h"
#include "transmission_lib_sfun.h"
#include "c13_transmission_lib.h"
#define _SF_MEX_LISTEN_FOR_CTRL_C(S)   sf_mex_listen_for_ctrl_c(NULL,S);

/* Type Definitions */

/* Named Constants */
#define CALL_EVENT                     (-1)
#define c13_IN_NO_ACTIVE_CHILD         ((uint8_T)0U)
#define c13_IN_TCC_OFF                 ((uint8_T)1U)
#define c13_IN_TCC_ON                  ((uint8_T)2U)

/* Variable Declarations */

/* Variable Definitions */
static real_T _sfTime_;

/* Function Declarations */
static void initialize_c13_transmission_lib(SFc13_transmission_libInstanceStruct
  *chartInstance);
static void initialize_params_c13_transmission_lib
  (SFc13_transmission_libInstanceStruct *chartInstance);
static void enable_c13_transmission_lib(SFc13_transmission_libInstanceStruct
  *chartInstance);
static void disable_c13_transmission_lib(SFc13_transmission_libInstanceStruct
  *chartInstance);
static const mxArray *get_sim_state_c13_transmission_lib
  (SFc13_transmission_libInstanceStruct *chartInstance);
static void set_sim_state_c13_transmission_lib
  (SFc13_transmission_libInstanceStruct *chartInstance, const mxArray *c13_st);
static void c13_set_sim_state_side_effects_c13_transmission_lib
  (SFc13_transmission_libInstanceStruct *chartInstance);
static void finalize_c13_transmission_lib(SFc13_transmission_libInstanceStruct
  *chartInstance);
static void sf_gateway_c13_transmission_lib(SFc13_transmission_libInstanceStruct
  *chartInstance);
static void initSimStructsc13_transmission_lib
  (SFc13_transmission_libInstanceStruct *chartInstance);
static void init_script_number_translation(uint32_T c13_machineNumber, uint32_T
  c13_chartNumber, uint32_T c13_instanceNumber);
static real_T c13_emlrt_marshallIn(SFc13_transmission_libInstanceStruct
  *chartInstance, const mxArray *c13_tcc_lockup, const char_T *c13_identifier);
static real_T c13_b_emlrt_marshallIn(SFc13_transmission_libInstanceStruct
  *chartInstance, const mxArray *c13_u, const emlrtMsgIdentifier *c13_parentId);
static uint8_T c13_c_emlrt_marshallIn(SFc13_transmission_libInstanceStruct
  *chartInstance, const mxArray *c13_b_is_active_c13_transmission_lib, const
  char_T *c13_identifier);
static uint8_T c13_d_emlrt_marshallIn(SFc13_transmission_libInstanceStruct
  *chartInstance, const mxArray *c13_u, const emlrtMsgIdentifier *c13_parentId);
static const mxArray *c13_e_emlrt_marshallIn
  (SFc13_transmission_libInstanceStruct *chartInstance, const mxArray
   *c13_b_setSimStateSideEffectsInfo, const char_T *c13_identifier);
static const mxArray *c13_f_emlrt_marshallIn
  (SFc13_transmission_libInstanceStruct *chartInstance, const mxArray *c13_u,
   const emlrtMsgIdentifier *c13_parentId);
static void init_dsm_address_info(SFc13_transmission_libInstanceStruct
  *chartInstance);

/* Function Definitions */
static void initialize_c13_transmission_lib(SFc13_transmission_libInstanceStruct
  *chartInstance)
{
  real_T *c13_tcc_lockup;
  c13_tcc_lockup = (real_T *)ssGetOutputPortSignal(chartInstance->S, 1);
  _sfTime_ = sf_get_time(chartInstance->S);
  chartInstance->c13_doSetSimStateSideEffects = 0U;
  chartInstance->c13_setSimStateSideEffectsInfo = NULL;
  chartInstance->c13_is_active_c13_transmission_lib = 0U;
  chartInstance->c13_is_c13_transmission_lib = c13_IN_NO_ACTIVE_CHILD;
  chartInstance->c13_timer = 0.0;
  if (!(sf_get_output_port_reusable(chartInstance->S, 1) != 0)) {
    *c13_tcc_lockup = 0.0;
  }
}

static void initialize_params_c13_transmission_lib
  (SFc13_transmission_libInstanceStruct *chartInstance)
{
  (void)chartInstance;
}

static void enable_c13_transmission_lib(SFc13_transmission_libInstanceStruct
  *chartInstance)
{
  _sfTime_ = sf_get_time(chartInstance->S);
}

static void disable_c13_transmission_lib(SFc13_transmission_libInstanceStruct
  *chartInstance)
{
  _sfTime_ = sf_get_time(chartInstance->S);
}

static const mxArray *get_sim_state_c13_transmission_lib
  (SFc13_transmission_libInstanceStruct *chartInstance)
{
  const mxArray *c13_st;
  const mxArray *c13_y = NULL;
  real_T c13_u;
  const mxArray *c13_b_y = NULL;
  real_T c13_b_u;
  const mxArray *c13_c_y = NULL;
  uint8_T c13_c_u;
  const mxArray *c13_d_y = NULL;
  uint8_T c13_d_u;
  const mxArray *c13_e_y = NULL;
  real_T *c13_tcc_lockup;
  c13_tcc_lockup = (real_T *)ssGetOutputPortSignal(chartInstance->S, 1);
  c13_st = NULL;
  c13_y = NULL;
  sf_mex_assign(&c13_y, sf_mex_createcellmatrix(4, 1), false);
  c13_u = *c13_tcc_lockup;
  c13_b_y = NULL;
  sf_mex_assign(&c13_b_y, sf_mex_create("y", &c13_u, 0, 0U, 0U, 0U, 0), false);
  sf_mex_setcell(c13_y, 0, c13_b_y);
  c13_b_u = chartInstance->c13_timer;
  c13_c_y = NULL;
  sf_mex_assign(&c13_c_y, sf_mex_create("y", &c13_b_u, 0, 0U, 0U, 0U, 0), false);
  sf_mex_setcell(c13_y, 1, c13_c_y);
  c13_c_u = chartInstance->c13_is_active_c13_transmission_lib;
  c13_d_y = NULL;
  sf_mex_assign(&c13_d_y, sf_mex_create("y", &c13_c_u, 3, 0U, 0U, 0U, 0), false);
  sf_mex_setcell(c13_y, 2, c13_d_y);
  c13_d_u = chartInstance->c13_is_c13_transmission_lib;
  c13_e_y = NULL;
  sf_mex_assign(&c13_e_y, sf_mex_create("y", &c13_d_u, 3, 0U, 0U, 0U, 0), false);
  sf_mex_setcell(c13_y, 3, c13_e_y);
  sf_mex_assign(&c13_st, c13_y, false);
  return c13_st;
}

static void set_sim_state_c13_transmission_lib
  (SFc13_transmission_libInstanceStruct *chartInstance, const mxArray *c13_st)
{
  const mxArray *c13_u;
  real_T *c13_tcc_lockup;
  c13_tcc_lockup = (real_T *)ssGetOutputPortSignal(chartInstance->S, 1);
  c13_u = sf_mex_dup(c13_st);
  *c13_tcc_lockup = c13_emlrt_marshallIn(chartInstance, sf_mex_dup
    (sf_mex_getcell(c13_u, 0)), "tcc_lockup");
  chartInstance->c13_timer = c13_emlrt_marshallIn(chartInstance, sf_mex_dup
    (sf_mex_getcell(c13_u, 1)), "timer");
  chartInstance->c13_is_active_c13_transmission_lib = c13_c_emlrt_marshallIn
    (chartInstance, sf_mex_dup(sf_mex_getcell(c13_u, 2)),
     "is_active_c13_transmission_lib");
  chartInstance->c13_is_c13_transmission_lib = c13_c_emlrt_marshallIn
    (chartInstance, sf_mex_dup(sf_mex_getcell(c13_u, 3)),
     "is_c13_transmission_lib");
  sf_mex_assign(&chartInstance->c13_setSimStateSideEffectsInfo,
                c13_e_emlrt_marshallIn(chartInstance, sf_mex_dup(sf_mex_getcell
    (c13_u, 4)), "setSimStateSideEffectsInfo"), true);
  sf_mex_destroy(&c13_u);
  chartInstance->c13_doSetSimStateSideEffects = 1U;
  sf_mex_destroy(&c13_st);
}

static void c13_set_sim_state_side_effects_c13_transmission_lib
  (SFc13_transmission_libInstanceStruct *chartInstance)
{
  if (chartInstance->c13_doSetSimStateSideEffects != 0) {
    chartInstance->c13_doSetSimStateSideEffects = 0U;
  }
}

static void finalize_c13_transmission_lib(SFc13_transmission_libInstanceStruct
  *chartInstance)
{
  sf_mex_destroy(&chartInstance->c13_setSimStateSideEffectsInfo);
}

static void sf_gateway_c13_transmission_lib(SFc13_transmission_libInstanceStruct
  *chartInstance)
{
  real_T *c13_step_time;
  real_T *c13_tcc_lockup;
  real_T *c13_lockup_allowed;
  real_T *c13_lock_spd;
  real_T *c13_lockup_spd;
  real_T *c13_lockup_delay_secs;
  real_T *c13_release_spd;
  c13_lockup_delay_secs = (real_T *)ssGetInputPortSignal(chartInstance->S, 5);
  c13_lockup_allowed = (real_T *)ssGetInputPortSignal(chartInstance->S, 4);
  c13_tcc_lockup = (real_T *)ssGetOutputPortSignal(chartInstance->S, 1);
  c13_release_spd = (real_T *)ssGetInputPortSignal(chartInstance->S, 3);
  c13_lockup_spd = (real_T *)ssGetInputPortSignal(chartInstance->S, 2);
  c13_step_time = (real_T *)ssGetInputPortSignal(chartInstance->S, 1);
  c13_lock_spd = (real_T *)ssGetInputPortSignal(chartInstance->S, 0);
  c13_set_sim_state_side_effects_c13_transmission_lib(chartInstance);
  _sfTime_ = sf_get_time(chartInstance->S);
  if (chartInstance->c13_is_active_c13_transmission_lib == 0U) {
    chartInstance->c13_is_active_c13_transmission_lib = 1U;
    chartInstance->c13_is_c13_transmission_lib = c13_IN_TCC_OFF;
    *c13_tcc_lockup = 0.0;
    chartInstance->c13_timer = 0.0;
  } else {
    switch (chartInstance->c13_is_c13_transmission_lib) {
     case c13_IN_TCC_OFF:
      if ((*c13_lockup_allowed != 0.0) && (*c13_lock_spd >= *c13_lockup_spd) &&
          (chartInstance->c13_timer >= *c13_lockup_delay_secs)) {
        chartInstance->c13_is_c13_transmission_lib = c13_IN_TCC_ON;
        *c13_tcc_lockup = 1.0;
      } else if ((*c13_lock_spd < *c13_lockup_spd) || (!(*c13_lockup_allowed !=
                   0.0))) {
        chartInstance->c13_is_c13_transmission_lib = c13_IN_TCC_OFF;
        *c13_tcc_lockup = 0.0;
        chartInstance->c13_timer = 0.0;
      } else {
        chartInstance->c13_timer += *c13_step_time;
      }
      break;

     case c13_IN_TCC_ON:
      if (*c13_lock_spd <= *c13_release_spd) {
        chartInstance->c13_is_c13_transmission_lib = c13_IN_TCC_OFF;
        *c13_tcc_lockup = 0.0;
        chartInstance->c13_timer = 0.0;
      }
      break;

     default:
      chartInstance->c13_is_c13_transmission_lib = c13_IN_NO_ACTIVE_CHILD;
      break;
    }
  }
}

static void initSimStructsc13_transmission_lib
  (SFc13_transmission_libInstanceStruct *chartInstance)
{
  (void)chartInstance;
}

static void init_script_number_translation(uint32_T c13_machineNumber, uint32_T
  c13_chartNumber, uint32_T c13_instanceNumber)
{
  (void)c13_machineNumber;
  (void)c13_chartNumber;
  (void)c13_instanceNumber;
}

const mxArray *sf_c13_transmission_lib_get_eml_resolved_functions_info(void)
{
  const mxArray *c13_nameCaptureInfo = NULL;
  c13_nameCaptureInfo = NULL;
  sf_mex_assign(&c13_nameCaptureInfo, sf_mex_create("nameCaptureInfo", NULL, 0,
    0U, 1U, 0U, 2, 0, 1), false);
  return c13_nameCaptureInfo;
}

static real_T c13_emlrt_marshallIn(SFc13_transmission_libInstanceStruct
  *chartInstance, const mxArray *c13_tcc_lockup, const char_T *c13_identifier)
{
  real_T c13_y;
  emlrtMsgIdentifier c13_thisId;
  c13_thisId.fIdentifier = c13_identifier;
  c13_thisId.fParent = NULL;
  c13_y = c13_b_emlrt_marshallIn(chartInstance, sf_mex_dup(c13_tcc_lockup),
    &c13_thisId);
  sf_mex_destroy(&c13_tcc_lockup);
  return c13_y;
}

static real_T c13_b_emlrt_marshallIn(SFc13_transmission_libInstanceStruct
  *chartInstance, const mxArray *c13_u, const emlrtMsgIdentifier *c13_parentId)
{
  real_T c13_y;
  real_T c13_d0;
  (void)chartInstance;
  sf_mex_import(c13_parentId, sf_mex_dup(c13_u), &c13_d0, 1, 0, 0U, 0, 0U, 0);
  c13_y = c13_d0;
  sf_mex_destroy(&c13_u);
  return c13_y;
}

static uint8_T c13_c_emlrt_marshallIn(SFc13_transmission_libInstanceStruct
  *chartInstance, const mxArray *c13_b_is_active_c13_transmission_lib, const
  char_T *c13_identifier)
{
  uint8_T c13_y;
  emlrtMsgIdentifier c13_thisId;
  c13_thisId.fIdentifier = c13_identifier;
  c13_thisId.fParent = NULL;
  c13_y = c13_d_emlrt_marshallIn(chartInstance, sf_mex_dup
    (c13_b_is_active_c13_transmission_lib), &c13_thisId);
  sf_mex_destroy(&c13_b_is_active_c13_transmission_lib);
  return c13_y;
}

static uint8_T c13_d_emlrt_marshallIn(SFc13_transmission_libInstanceStruct
  *chartInstance, const mxArray *c13_u, const emlrtMsgIdentifier *c13_parentId)
{
  uint8_T c13_y;
  uint8_T c13_u0;
  (void)chartInstance;
  sf_mex_import(c13_parentId, sf_mex_dup(c13_u), &c13_u0, 1, 3, 0U, 0, 0U, 0);
  c13_y = c13_u0;
  sf_mex_destroy(&c13_u);
  return c13_y;
}

static const mxArray *c13_e_emlrt_marshallIn
  (SFc13_transmission_libInstanceStruct *chartInstance, const mxArray
   *c13_b_setSimStateSideEffectsInfo, const char_T *c13_identifier)
{
  const mxArray *c13_y = NULL;
  emlrtMsgIdentifier c13_thisId;
  c13_y = NULL;
  c13_thisId.fIdentifier = c13_identifier;
  c13_thisId.fParent = NULL;
  sf_mex_assign(&c13_y, c13_f_emlrt_marshallIn(chartInstance, sf_mex_dup
    (c13_b_setSimStateSideEffectsInfo), &c13_thisId), false);
  sf_mex_destroy(&c13_b_setSimStateSideEffectsInfo);
  return c13_y;
}

static const mxArray *c13_f_emlrt_marshallIn
  (SFc13_transmission_libInstanceStruct *chartInstance, const mxArray *c13_u,
   const emlrtMsgIdentifier *c13_parentId)
{
  const mxArray *c13_y = NULL;
  (void)chartInstance;
  (void)c13_parentId;
  c13_y = NULL;
  sf_mex_assign(&c13_y, sf_mex_duplicatearraysafe(&c13_u), false);
  sf_mex_destroy(&c13_u);
  return c13_y;
}

static void init_dsm_address_info(SFc13_transmission_libInstanceStruct
  *chartInstance)
{
  (void)chartInstance;
}

/* SFunction Glue Code */
#ifdef utFree
#undef utFree
#endif

#ifdef utMalloc
#undef utMalloc
#endif

#ifdef __cplusplus

extern "C" void *utMalloc(size_t size);
extern "C" void utFree(void*);

#else

extern void *utMalloc(size_t size);
extern void utFree(void*);

#endif

void sf_c13_transmission_lib_get_check_sum(mxArray *plhs[])
{
  ((real_T *)mxGetPr((plhs[0])))[0] = (real_T)(2817857444U);
  ((real_T *)mxGetPr((plhs[0])))[1] = (real_T)(2036739399U);
  ((real_T *)mxGetPr((plhs[0])))[2] = (real_T)(569051470U);
  ((real_T *)mxGetPr((plhs[0])))[3] = (real_T)(324459119U);
}

mxArray *sf_c13_transmission_lib_get_autoinheritance_info(void)
{
  const char *autoinheritanceFields[] = { "checksum", "inputs", "parameters",
    "outputs", "locals" };

  mxArray *mxAutoinheritanceInfo = mxCreateStructMatrix(1,1,5,
    autoinheritanceFields);

  {
    mxArray *mxChecksum = mxCreateString("Vpos04yCJf4cbC8vCk2gdC");
    mxSetField(mxAutoinheritanceInfo,0,"checksum",mxChecksum);
  }

  {
    const char *dataFields[] = { "size", "type", "complexity" };

    mxArray *mxData = mxCreateStructMatrix(1,6,3,dataFields);

    {
      mxArray *mxSize = mxCreateDoubleMatrix(1,2,mxREAL);
      double *pr = mxGetPr(mxSize);
      pr[0] = (double)(1);
      pr[1] = (double)(1);
      mxSetField(mxData,0,"size",mxSize);
    }

    {
      const char *typeFields[] = { "base", "fixpt" };

      mxArray *mxType = mxCreateStructMatrix(1,1,2,typeFields);
      mxSetField(mxType,0,"base",mxCreateDoubleScalar(10));
      mxSetField(mxType,0,"fixpt",mxCreateDoubleMatrix(0,0,mxREAL));
      mxSetField(mxData,0,"type",mxType);
    }

    mxSetField(mxData,0,"complexity",mxCreateDoubleScalar(0));

    {
      mxArray *mxSize = mxCreateDoubleMatrix(1,2,mxREAL);
      double *pr = mxGetPr(mxSize);
      pr[0] = (double)(1);
      pr[1] = (double)(1);
      mxSetField(mxData,1,"size",mxSize);
    }

    {
      const char *typeFields[] = { "base", "fixpt" };

      mxArray *mxType = mxCreateStructMatrix(1,1,2,typeFields);
      mxSetField(mxType,0,"base",mxCreateDoubleScalar(10));
      mxSetField(mxType,0,"fixpt",mxCreateDoubleMatrix(0,0,mxREAL));
      mxSetField(mxData,1,"type",mxType);
    }

    mxSetField(mxData,1,"complexity",mxCreateDoubleScalar(0));

    {
      mxArray *mxSize = mxCreateDoubleMatrix(1,2,mxREAL);
      double *pr = mxGetPr(mxSize);
      pr[0] = (double)(1);
      pr[1] = (double)(1);
      mxSetField(mxData,2,"size",mxSize);
    }

    {
      const char *typeFields[] = { "base", "fixpt" };

      mxArray *mxType = mxCreateStructMatrix(1,1,2,typeFields);
      mxSetField(mxType,0,"base",mxCreateDoubleScalar(10));
      mxSetField(mxType,0,"fixpt",mxCreateDoubleMatrix(0,0,mxREAL));
      mxSetField(mxData,2,"type",mxType);
    }

    mxSetField(mxData,2,"complexity",mxCreateDoubleScalar(0));

    {
      mxArray *mxSize = mxCreateDoubleMatrix(1,2,mxREAL);
      double *pr = mxGetPr(mxSize);
      pr[0] = (double)(1);
      pr[1] = (double)(1);
      mxSetField(mxData,3,"size",mxSize);
    }

    {
      const char *typeFields[] = { "base", "fixpt" };

      mxArray *mxType = mxCreateStructMatrix(1,1,2,typeFields);
      mxSetField(mxType,0,"base",mxCreateDoubleScalar(10));
      mxSetField(mxType,0,"fixpt",mxCreateDoubleMatrix(0,0,mxREAL));
      mxSetField(mxData,3,"type",mxType);
    }

    mxSetField(mxData,3,"complexity",mxCreateDoubleScalar(0));

    {
      mxArray *mxSize = mxCreateDoubleMatrix(1,2,mxREAL);
      double *pr = mxGetPr(mxSize);
      pr[0] = (double)(1);
      pr[1] = (double)(1);
      mxSetField(mxData,4,"size",mxSize);
    }

    {
      const char *typeFields[] = { "base", "fixpt" };

      mxArray *mxType = mxCreateStructMatrix(1,1,2,typeFields);
      mxSetField(mxType,0,"base",mxCreateDoubleScalar(10));
      mxSetField(mxType,0,"fixpt",mxCreateDoubleMatrix(0,0,mxREAL));
      mxSetField(mxData,4,"type",mxType);
    }

    mxSetField(mxData,4,"complexity",mxCreateDoubleScalar(0));

    {
      mxArray *mxSize = mxCreateDoubleMatrix(1,2,mxREAL);
      double *pr = mxGetPr(mxSize);
      pr[0] = (double)(1);
      pr[1] = (double)(1);
      mxSetField(mxData,5,"size",mxSize);
    }

    {
      const char *typeFields[] = { "base", "fixpt" };

      mxArray *mxType = mxCreateStructMatrix(1,1,2,typeFields);
      mxSetField(mxType,0,"base",mxCreateDoubleScalar(10));
      mxSetField(mxType,0,"fixpt",mxCreateDoubleMatrix(0,0,mxREAL));
      mxSetField(mxData,5,"type",mxType);
    }

    mxSetField(mxData,5,"complexity",mxCreateDoubleScalar(0));
    mxSetField(mxAutoinheritanceInfo,0,"inputs",mxData);
  }

  {
    mxSetField(mxAutoinheritanceInfo,0,"parameters",mxCreateDoubleMatrix(0,0,
                mxREAL));
  }

  {
    const char *dataFields[] = { "size", "type", "complexity" };

    mxArray *mxData = mxCreateStructMatrix(1,1,3,dataFields);

    {
      mxArray *mxSize = mxCreateDoubleMatrix(1,2,mxREAL);
      double *pr = mxGetPr(mxSize);
      pr[0] = (double)(1);
      pr[1] = (double)(1);
      mxSetField(mxData,0,"size",mxSize);
    }

    {
      const char *typeFields[] = { "base", "fixpt" };

      mxArray *mxType = mxCreateStructMatrix(1,1,2,typeFields);
      mxSetField(mxType,0,"base",mxCreateDoubleScalar(10));
      mxSetField(mxType,0,"fixpt",mxCreateDoubleMatrix(0,0,mxREAL));
      mxSetField(mxData,0,"type",mxType);
    }

    mxSetField(mxData,0,"complexity",mxCreateDoubleScalar(0));
    mxSetField(mxAutoinheritanceInfo,0,"outputs",mxData);
  }

  {
    mxSetField(mxAutoinheritanceInfo,0,"locals",mxCreateDoubleMatrix(0,0,mxREAL));
  }

  return(mxAutoinheritanceInfo);
}

mxArray *sf_c13_transmission_lib_third_party_uses_info(void)
{
  mxArray * mxcell3p = mxCreateCellMatrix(1,0);
  return(mxcell3p);
}

mxArray *sf_c13_transmission_lib_updateBuildInfo_args_info(void)
{
  mxArray *mxBIArgs = mxCreateCellMatrix(1,0);
  return mxBIArgs;
}

static const mxArray *sf_get_sim_state_info_c13_transmission_lib(void)
{
  const char *infoFields[] = { "chartChecksum", "varInfo" };

  mxArray *mxInfo = mxCreateStructMatrix(1, 1, 2, infoFields);
  const char *infoEncStr[] = {
    "100 S1x4'type','srcId','name','auxInfo'{{M[1],M[44],T\"tcc_lockup\",},{M[3],M[89],T\"timer\",},{M[8],M[0],T\"is_active_c13_transmission_lib\",},{M[9],M[0],T\"is_c13_transmission_lib\",}}"
  };

  mxArray *mxVarInfo = sf_mex_decode_encoded_mx_struct_array(infoEncStr, 4, 10);
  mxArray *mxChecksum = mxCreateDoubleMatrix(1, 4, mxREAL);
  sf_c13_transmission_lib_get_check_sum(&mxChecksum);
  mxSetField(mxInfo, 0, infoFields[0], mxChecksum);
  mxSetField(mxInfo, 0, infoFields[1], mxVarInfo);
  return mxInfo;
}

static const char* sf_get_instance_specialization(void)
{
  return "JcLyHoJLqFrvdwBQg0fgVD";
}

static void sf_opaque_initialize_c13_transmission_lib(void *chartInstanceVar)
{
  initialize_params_c13_transmission_lib((SFc13_transmission_libInstanceStruct*)
    chartInstanceVar);
  initialize_c13_transmission_lib((SFc13_transmission_libInstanceStruct*)
    chartInstanceVar);
}

static void sf_opaque_enable_c13_transmission_lib(void *chartInstanceVar)
{
  enable_c13_transmission_lib((SFc13_transmission_libInstanceStruct*)
    chartInstanceVar);
}

static void sf_opaque_disable_c13_transmission_lib(void *chartInstanceVar)
{
  disable_c13_transmission_lib((SFc13_transmission_libInstanceStruct*)
    chartInstanceVar);
}

static void sf_opaque_gateway_c13_transmission_lib(void *chartInstanceVar)
{
  sf_gateway_c13_transmission_lib((SFc13_transmission_libInstanceStruct*)
    chartInstanceVar);
}

extern const mxArray* sf_internal_get_sim_state_c13_transmission_lib(SimStruct*
  S)
{
  ChartRunTimeInfo * crtInfo = (ChartRunTimeInfo *)(ssGetUserData(S));
  ChartInfoStruct * chartInfo = (ChartInfoStruct *)(crtInfo->instanceInfo);
  mxArray *plhs[1] = { NULL };

  mxArray *prhs[4];
  int mxError = 0;
  prhs[0] = mxCreateString("chart_simctx_raw2high");
  prhs[1] = mxCreateDoubleScalar(ssGetSFuncBlockHandle(S));
  prhs[2] = (mxArray*) get_sim_state_c13_transmission_lib
    ((SFc13_transmission_libInstanceStruct*)chartInfo->chartInstance);/* raw sim ctx */
  prhs[3] = (mxArray*) sf_get_sim_state_info_c13_transmission_lib();/* state var info */
  mxError = sf_mex_call_matlab(1, plhs, 4, prhs, "sfprivate");
  mxDestroyArray(prhs[0]);
  mxDestroyArray(prhs[1]);
  mxDestroyArray(prhs[2]);
  mxDestroyArray(prhs[3]);
  if (mxError || plhs[0] == NULL) {
    sf_mex_error_message("Stateflow Internal Error: \nError calling 'chart_simctx_raw2high'.\n");
  }

  return plhs[0];
}

extern void sf_internal_set_sim_state_c13_transmission_lib(SimStruct* S, const
  mxArray *st)
{
  ChartRunTimeInfo * crtInfo = (ChartRunTimeInfo *)(ssGetUserData(S));
  ChartInfoStruct * chartInfo = (ChartInfoStruct *)(crtInfo->instanceInfo);
  mxArray *plhs[1] = { NULL };

  mxArray *prhs[3];
  int mxError = 0;
  prhs[0] = mxCreateString("chart_simctx_high2raw");
  prhs[1] = mxDuplicateArray(st);      /* high level simctx */
  prhs[2] = (mxArray*) sf_get_sim_state_info_c13_transmission_lib();/* state var info */
  mxError = sf_mex_call_matlab(1, plhs, 3, prhs, "sfprivate");
  mxDestroyArray(prhs[0]);
  mxDestroyArray(prhs[1]);
  mxDestroyArray(prhs[2]);
  if (mxError || plhs[0] == NULL) {
    sf_mex_error_message("Stateflow Internal Error: \nError calling 'chart_simctx_high2raw'.\n");
  }

  set_sim_state_c13_transmission_lib((SFc13_transmission_libInstanceStruct*)
    chartInfo->chartInstance, mxDuplicateArray(plhs[0]));
  mxDestroyArray(plhs[0]);
}

static const mxArray* sf_opaque_get_sim_state_c13_transmission_lib(SimStruct* S)
{
  return sf_internal_get_sim_state_c13_transmission_lib(S);
}

static void sf_opaque_set_sim_state_c13_transmission_lib(SimStruct* S, const
  mxArray *st)
{
  sf_internal_set_sim_state_c13_transmission_lib(S, st);
}

static void sf_opaque_terminate_c13_transmission_lib(void *chartInstanceVar)
{
  if (chartInstanceVar!=NULL) {
    SimStruct *S = ((SFc13_transmission_libInstanceStruct*) chartInstanceVar)->S;
    ChartRunTimeInfo * crtInfo = (ChartRunTimeInfo *)(ssGetUserData(S));
    if (sim_mode_is_rtw_gen(S) || sim_mode_is_external(S)) {
      sf_clear_rtw_identifier(S);
      unload_transmission_lib_optimization_info();
    }

    finalize_c13_transmission_lib((SFc13_transmission_libInstanceStruct*)
      chartInstanceVar);
    utFree((void *)chartInstanceVar);
    if (crtInfo != NULL) {
      utFree((void *)crtInfo);
    }

    ssSetUserData(S,NULL);
  }
}

static void sf_opaque_init_subchart_simstructs(void *chartInstanceVar)
{
  initSimStructsc13_transmission_lib((SFc13_transmission_libInstanceStruct*)
    chartInstanceVar);
}

extern unsigned int sf_machine_global_initializer_called(void);
static void mdlProcessParameters_c13_transmission_lib(SimStruct *S)
{
  int i;
  for (i=0;i<ssGetNumRunTimeParams(S);i++) {
    if (ssGetSFcnParamTunable(S,i)) {
      ssUpdateDlgParamAsRunTimeParam(S,i);
    }
  }

  if (sf_machine_global_initializer_called()) {
    ChartRunTimeInfo * crtInfo = (ChartRunTimeInfo *)(ssGetUserData(S));
    ChartInfoStruct * chartInfo = (ChartInfoStruct *)(crtInfo->instanceInfo);
    initialize_params_c13_transmission_lib((SFc13_transmission_libInstanceStruct*)
      (chartInfo->chartInstance));
  }
}

static void mdlSetWorkWidths_c13_transmission_lib(SimStruct *S)
{
  if (sim_mode_is_rtw_gen(S) || sim_mode_is_external(S)) {
    mxArray *infoStruct = load_transmission_lib_optimization_info();
    int_T chartIsInlinable =
      (int_T)sf_is_chart_inlinable(sf_get_instance_specialization(),infoStruct,
      13);
    ssSetStateflowIsInlinable(S,chartIsInlinable);
    ssSetRTWCG(S,sf_rtw_info_uint_prop(sf_get_instance_specialization(),
                infoStruct,13,"RTWCG"));
    ssSetEnableFcnIsTrivial(S,1);
    ssSetDisableFcnIsTrivial(S,1);
    ssSetNotMultipleInlinable(S,sf_rtw_info_uint_prop
      (sf_get_instance_specialization(),infoStruct,13,
       "gatewayCannotBeInlinedMultipleTimes"));
    sf_update_buildInfo(sf_get_instance_specialization(),infoStruct,13);
    if (chartIsInlinable) {
      ssSetInputPortOptimOpts(S, 0, SS_REUSABLE_AND_LOCAL);
      ssSetInputPortOptimOpts(S, 1, SS_REUSABLE_AND_LOCAL);
      ssSetInputPortOptimOpts(S, 2, SS_REUSABLE_AND_LOCAL);
      ssSetInputPortOptimOpts(S, 3, SS_REUSABLE_AND_LOCAL);
      ssSetInputPortOptimOpts(S, 4, SS_REUSABLE_AND_LOCAL);
      ssSetInputPortOptimOpts(S, 5, SS_REUSABLE_AND_LOCAL);
      sf_mark_chart_expressionable_inputs(S,sf_get_instance_specialization(),
        infoStruct,13,6);
      sf_mark_chart_reusable_outputs(S,sf_get_instance_specialization(),
        infoStruct,13,1);
    }

    {
      unsigned int outPortIdx;
      for (outPortIdx=1; outPortIdx<=1; ++outPortIdx) {
        ssSetOutputPortOptimizeInIR(S, outPortIdx, 1U);
      }
    }

    {
      unsigned int inPortIdx;
      for (inPortIdx=0; inPortIdx < 6; ++inPortIdx) {
        ssSetInputPortOptimizeInIR(S, inPortIdx, 1U);
      }
    }

    sf_set_rtw_dwork_info(S,sf_get_instance_specialization(),infoStruct,13);
    ssSetHasSubFunctions(S,!(chartIsInlinable));
  } else {
  }

  ssSetOptions(S,ssGetOptions(S)|SS_OPTION_WORKS_WITH_CODE_REUSE);
  ssSetChecksum0(S,(1428025545U));
  ssSetChecksum1(S,(4095885693U));
  ssSetChecksum2(S,(2666078625U));
  ssSetChecksum3(S,(278679630U));
  ssSetmdlDerivatives(S, NULL);
  ssSetExplicitFCSSCtrl(S,1);
  ssSupportsMultipleExecInstances(S,1);
}

static void mdlRTW_c13_transmission_lib(SimStruct *S)
{
  if (sim_mode_is_rtw_gen(S)) {
    ssWriteRTWStrParam(S, "StateflowChartType", "Stateflow");
  }
}

static void mdlStart_c13_transmission_lib(SimStruct *S)
{
  SFc13_transmission_libInstanceStruct *chartInstance;
  ChartRunTimeInfo * crtInfo = (ChartRunTimeInfo *)utMalloc(sizeof
    (ChartRunTimeInfo));
  chartInstance = (SFc13_transmission_libInstanceStruct *)utMalloc(sizeof
    (SFc13_transmission_libInstanceStruct));
  memset(chartInstance, 0, sizeof(SFc13_transmission_libInstanceStruct));
  if (chartInstance==NULL) {
    sf_mex_error_message("Could not allocate memory for chart instance.");
  }

  chartInstance->chartInfo.chartInstance = chartInstance;
  chartInstance->chartInfo.isEMLChart = 0;
  chartInstance->chartInfo.chartInitialized = 0;
  chartInstance->chartInfo.sFunctionGateway =
    sf_opaque_gateway_c13_transmission_lib;
  chartInstance->chartInfo.initializeChart =
    sf_opaque_initialize_c13_transmission_lib;
  chartInstance->chartInfo.terminateChart =
    sf_opaque_terminate_c13_transmission_lib;
  chartInstance->chartInfo.enableChart = sf_opaque_enable_c13_transmission_lib;
  chartInstance->chartInfo.disableChart = sf_opaque_disable_c13_transmission_lib;
  chartInstance->chartInfo.getSimState =
    sf_opaque_get_sim_state_c13_transmission_lib;
  chartInstance->chartInfo.setSimState =
    sf_opaque_set_sim_state_c13_transmission_lib;
  chartInstance->chartInfo.getSimStateInfo =
    sf_get_sim_state_info_c13_transmission_lib;
  chartInstance->chartInfo.zeroCrossings = NULL;
  chartInstance->chartInfo.outputs = NULL;
  chartInstance->chartInfo.derivatives = NULL;
  chartInstance->chartInfo.mdlRTW = mdlRTW_c13_transmission_lib;
  chartInstance->chartInfo.mdlStart = mdlStart_c13_transmission_lib;
  chartInstance->chartInfo.mdlSetWorkWidths =
    mdlSetWorkWidths_c13_transmission_lib;
  chartInstance->chartInfo.extModeExec = NULL;
  chartInstance->chartInfo.restoreLastMajorStepConfiguration = NULL;
  chartInstance->chartInfo.restoreBeforeLastMajorStepConfiguration = NULL;
  chartInstance->chartInfo.storeCurrentConfiguration = NULL;
  chartInstance->S = S;
  crtInfo->instanceInfo = (&(chartInstance->chartInfo));
  crtInfo->isJITEnabled = false;
  ssSetUserData(S,(void *)(crtInfo));  /* register the chart instance with simstruct */
  init_dsm_address_info(chartInstance);
  if (!sim_mode_is_rtw_gen(S)) {
  }

  sf_opaque_init_subchart_simstructs(chartInstance->chartInfo.chartInstance);
}

void c13_transmission_lib_method_dispatcher(SimStruct *S, int_T method, void
  *data)
{
  switch (method) {
   case SS_CALL_MDL_START:
    mdlStart_c13_transmission_lib(S);
    break;

   case SS_CALL_MDL_SET_WORK_WIDTHS:
    mdlSetWorkWidths_c13_transmission_lib(S);
    break;

   case SS_CALL_MDL_PROCESS_PARAMETERS:
    mdlProcessParameters_c13_transmission_lib(S);
    break;

   default:
    /* Unhandled method */
    sf_mex_error_message("Stateflow Internal Error:\n"
                         "Error calling c13_transmission_lib_method_dispatcher.\n"
                         "Can't handle method %d.\n", method);
    break;
  }
}
